# Include file for GURPS bonus display.
#
@var adjNames[0]
@var adjValues[0]
@var adjList[0]
#
@sub getAllBonuses()
@getBonuses('Advantages')
@getBonuses('Powers')
@getBonuses('Disadvantages')
@getBonuses('Skills')
@getBonuses('Spells')
@endsub
#
@sub splitAdj(adj, adjustments)
@var adjArr[0]
@var i
@n=split(adj, "/[;!]/", adjArr)
@for i = 1; i <= sizeof(adjArr); i = i + 1
	@n=addElement(adjustments, adjArr[i])
@endfor
@endsub
#
# Execute this for each list that can have bonuses on other items.
#
@sub getBonuses(listName)
@var adjustments[0]
@var optTypes[0]
@var optExps[0]
@var target, values, n, i, adj
@foreach(%listName%)
	@n=removeAllElements(adjustments)
	@n=listOptions("optrawtype", "", optTypes)
	@n=listOptions("optexp", "", optExps)
	@for i = 1; i <= sizeof(optTypes); i = i + 1
		@if optTypes[i] = "adj"
			@splitAdj(optExps[i], adjustments)
		@endif
	@endfor
	@adj=@adj
	@if adj != ""
		@splitAdj(adj, adjustments)
	@endif
	@for i=1; i <=sizeof(adjustments); i = i + 1
		@n=split(replaceString(adjustments[i], '"',''), "/ *[-+=*] */", "target", "values")
		@if target
			@if (strindex(target, ":"))
				@n=split(target, "/ *: */", "lst", "item")
				@n=addElement(adjValues, item)
				@n=addElement(adjList, lst)
			@else
				@n=addElement(adjValues, target)
				@n=addElement(adjList, 0)
			@endif
			@n=addElement(adjNames, @name)
		@endif
	@endfor
@endforeach
@endsub
#
# Execute this for each list that can have items adjusted by bonuses.
#
@sub listBonuses(listName, dispNames)
@var i, n
@n=removeAllElements(dispNames)
@foreach(%listName%)
	@for i = 1; i <= sizeof(adjNames); i = i + 1
		@if adjList[i] and strindex(listName, adjList[i]) = 1
#			Adjustment to a category, specific item or variable name in a list.
			@if incategory(adjValues[i]) or adjValues[i] = @name or adjValues[i] = @varname
				@if index(dispNames, adjNames[i]) <= 0
					@n=addElement(dispNames, adjNames[i])
				@endif
			@endif
		@elseif adjList[i] = 0 and adjValues[i] = @varName
#			Adjustment to variable name.
			@if index(dispNames, adjNames[i]) <= 0
				@n=addElement(dispNames, adjNames[i])
			@endif
		@endif
	@endfor
@endforeach
@endsub
#
@sub printBonuses(listName)
@var bonusItemNames[0]
@var i
@listBonuses(listName, bonusItemNames)
@if sizeof(bonusItemNames) > 0
	@output	
	@output	*Cost modifiers: \
	@for i = 1; i <= sizeof(bonusItemNames); i = i + 1
		@output %bonusItemNames[i]%?i<sizeof(bonusItemNames)?, ??\
	@endfor
	@output .
@endif
@endsub